/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.fakebungee.plugin.events;

import de.rayzs.fakebungee.configurator.FileConfigurator;
import de.rayzs.fakebungee.configurator.SettingOption;
import de.rayzs.fakebungee.listener.PlayerEnterWorldEvent;
import de.rayzs.fakebungee.listener.PlayerLeaveWorldEvent;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.PluginManager;

public class PlayerUpdateWorld
implements Listener {
    private final Server server;
    private final PluginManager pluginManager;
    private final FileConfigurator messages;
    private final boolean sendEnterMessage;
    private final boolean sendLeaveMessage;

    public PlayerUpdateWorld(Server server, PluginManager pluginManager, FileConfigurator settings, FileConfigurator messages) {
        this.server = server;
        this.pluginManager = pluginManager;
        this.messages = messages;
        this.sendEnterMessage = (Boolean)settings.get(SettingOption.SETTING_WORLD_SENDENTERMESSAGE);
        this.sendLeaveMessage = (Boolean)settings.get(SettingOption.SETTING_WORLD_SENDLEAVEMESSAGE);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        World enteredWorld = player.getWorld();
        PlayerEnterWorldEvent playerEnterWorldEvent = new PlayerEnterWorldEvent(this.messages, player, enteredWorld);
        this.pluginManager.callEvent((Event)playerEnterWorldEvent);
        this.update(player, playerEnterWorldEvent);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        World leftWorld = player.getWorld();
        PlayerLeaveWorldEvent playerLeaveWorldEvent = new PlayerLeaveWorldEvent(this.messages, player, leftWorld);
        this.pluginManager.callEvent((Event)playerLeaveWorldEvent);
        this.update(player, playerLeaveWorldEvent);
    }

    @EventHandler
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        World enteredWorld = player.getWorld();
        World leftWorld = event.getFrom();
        PlayerEnterWorldEvent playerEnterWorldEvent = new PlayerEnterWorldEvent(this.messages, player, enteredWorld);
        PlayerLeaveWorldEvent playerLeaveWorldEvent = new PlayerLeaveWorldEvent(this.messages, player, leftWorld);
        this.pluginManager.callEvent((Event)playerEnterWorldEvent);
        this.pluginManager.callEvent((Event)playerLeaveWorldEvent);
        this.update(player, playerEnterWorldEvent, playerLeaveWorldEvent);
    }

    protected void update(Player player, PlayerEnterWorldEvent playerEnterWorldEvent, PlayerLeaveWorldEvent playerLeaveWorldEvent) {
        World enteredWorld = playerEnterWorldEvent.getEnteredWorld();
        World leftWorld = playerLeaveWorldEvent.getLeftWorld();
        this.server.getOnlinePlayers().forEach(players -> {
            boolean hidePlayer = true;
            if (enteredWorld == players.getWorld()) {
                if (this.sendEnterMessage) {
                    players.sendMessage(playerEnterWorldEvent.getPlayerEnterWorldMessage());
                }
                hidePlayer = false;
            } else if (leftWorld == players.getWorld() && this.sendLeaveMessage) {
                players.sendMessage(playerLeaveWorldEvent.getPlayerLeaveWorldMessage());
            }
            if (hidePlayer) {
                players.hidePlayer(player);
            } else {
                players.showPlayer(player);
            }
        });
    }

    protected void update(Player player, PlayerEnterWorldEvent playerEnterWorldEvent) {
        World enteredWorld = playerEnterWorldEvent.getEnteredWorld();
        this.server.getOnlinePlayers().forEach(players -> {
            if (enteredWorld == players.getWorld() && this.sendEnterMessage) {
                players.sendMessage(playerEnterWorldEvent.getPlayerEnterWorldMessage());
            } else {
                players.hidePlayer(player);
            }
        });
    }

    protected void update(Player player, PlayerLeaveWorldEvent playerLeaveWorldEvent) {
        World leftWorld = playerLeaveWorldEvent.getLeftWorld();
        this.server.getOnlinePlayers().forEach(players -> {
            if (leftWorld == players.getWorld() && this.sendLeaveMessage) {
                players.sendMessage(playerLeaveWorldEvent.getPlayerLeaveWorldMessage());
            }
        });
    }
}

