/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.fakebungee.plugin.events;

import de.rayzs.fakebungee.configurator.FileConfigurator;
import de.rayzs.fakebungee.configurator.SettingOption;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class PlayerFakeCommand
implements Listener {
    private final String fakeBungeeCommand;
    private final String fakeOtherCommand;
    private final FileConfigurator settings;
    private final FileConfigurator messages;
    private List<String> commands;

    public PlayerFakeCommand(FileConfigurator settings, FileConfigurator messages) {
        this.settings = settings;
        this.messages = messages;
        this.commands = new ArrayList<String>();
        try {
            this.commands = (List)settings.get(SettingOption.SETTING_COMMANDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fakeBungeeCommand = (String)messages.get(SettingOption.MESSAGE_COMMAND_BUNGEE);
        this.fakeOtherCommand = (String)messages.get(SettingOption.MESSAGE_COMMAND_OTHER);
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().split("/")[1].split(" ")[0].toLowerCase();
        if (command.startsWith("bungee")) {
            player.sendMessage(this.fakeBungeeCommand);
            event.setCancelled(true);
            return;
        }
        if (this.commands.contains(command)) {
            player.sendMessage(this.fakeOtherCommand);
            event.setCancelled(true);
        }
    }
}

