/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.fakebungee.plugin;

import de.rayzs.fakebungee.bstats.bukkit.Metrics;
import de.rayzs.fakebungee.configurator.FileConfigurator;
import de.rayzs.fakebungee.configurator.SettingOption;
import de.rayzs.fakebungee.plugin.commands.AdminCommand;
import de.rayzs.fakebungee.plugin.commands.AdminTabCompleter;
import de.rayzs.fakebungee.plugin.events.PlayerFakeCommand;
import de.rayzs.fakebungee.plugin.events.PlayerSplitChat;
import de.rayzs.fakebungee.plugin.events.PlayerUpdateWorld;
import java.util.Arrays;
import org.bukkit.Server;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class FakeBungee
extends JavaPlugin {
    private final String FILE_PATH = "plugins/FakeBungee";
    private Server server;
    private FileConfigurator settings;
    private FileConfigurator messages;
    private PluginManager pluginManager;

    public void onEnable() {
        new Metrics(this, 15149);
        this.server = this.getServer();
        this.pluginManager = this.server.getPluginManager();
        this.settings = new FileConfigurator((Plugin)this, "config", "plugins/FakeBungee");
        this.messages = new FileConfigurator((Plugin)this, "messages", "plugins/FakeBungee");
        if (this.settings.useDefaultSettings()) {
            this.loadDefaultSettings();
        }
        if (this.messages.useDefaultSettings()) {
            this.loadDefaultMessages();
        }
        PluginCommand[] fakeBungeeCommands = new PluginCommand[]{this.getCommand("fakebungee"), this.getCommand("fb")};
        AdminCommand adminCommandExecutor = new AdminCommand(this);
        AdminTabCompleter adminTabCompleter = new AdminTabCompleter();
        for (PluginCommand fakeBungeeCommand : fakeBungeeCommands) {
            fakeBungeeCommand.setExecutor((CommandExecutor)adminCommandExecutor);
            fakeBungeeCommand.setTabCompleter((TabCompleter)adminTabCompleter);
        }
        this.registerEvents();
    }

    public void disablePlugin() {
        this.pluginManager.disablePlugin((Plugin)this);
    }

    public void registerEvents() {
        this.pluginManager.registerEvents((Listener)new PlayerUpdateWorld(this.server, this.pluginManager, this.settings, this.messages), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerSplitChat(this.server), (Plugin)this);
        this.pluginManager.registerEvents((Listener)new PlayerFakeCommand(this.settings, this.messages), (Plugin)this);
    }

    public void update() {
        HandlerList.unregisterAll((Plugin)this);
        this.settings = new FileConfigurator((Plugin)this, "config", "plugins/FakeBungee");
        this.messages = new FileConfigurator((Plugin)this, "messages", "plugins/FakeBungee");
        this.registerEvents();
    }

    public void loadDefaultSettings() {
        this.settings.set(SettingOption.SETTING_WORLD_SENDENTERMESSAGE, true);
        this.settings.set(SettingOption.SETTING_WORLD_SENDLEAVEMESSAGE, true);
        this.settings.set(SettingOption.SETTING_COMMANDS, Arrays.asList("server", "glist", "send", "alert", "end", "find", "ip"));
        this.settings.save();
    }

    public void loadDefaultMessages() {
        this.messages.set(SettingOption.MESSAGE_WORLD_ENTER, "&a%player% entered the world &2%world%!");
        this.messages.set(SettingOption.MESSAGE_WORLD_LEAVE, "&c%player% left the world &4%world%!");
        this.messages.set(SettingOption.MESSAGE_COMMAND_BUNGEE, "&9This server is running BungeeCord version git:Waterfall-Bootstrap:1.18-R0.1-SNAPSHOT:ba3bbcc:483 by md_5");
        this.messages.set(SettingOption.MESSAGE_COMMAND_OTHER, "&cYou do not have permission to execute this command!");
        this.messages.save();
    }
}

