/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.fakebungee.configurator;

import de.rayzs.fakebungee.configurator.SettingOption;
import java.io.File;
import java.util.HashMap;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FileConfigurator {
    private final Plugin plugin;
    private final String fileName;
    private final String filePath;
    private final HashMap<SettingOption, Object> hashedValues;
    private boolean defaultSettings = false;
    private File file;
    private YamlConfiguration configuration;

    public FileConfigurator(Plugin plugin, String fileName, String filePath) {
        this.plugin = plugin;
        this.fileName = fileName;
        this.filePath = filePath;
        this.hashedValues = new HashMap();
        try {
            boolean directoryCreation;
            if (!(new File(filePath).exists() && new File(filePath).isDirectory() || (directoryCreation = new File(filePath).mkdirs()))) {
                plugin.getLogger().warning("Directory couldn't be created!");
                return;
            }
            this.file = new File(filePath, fileName + ".yml");
            if (!this.file.exists()) {
                boolean fileCreation = this.file.createNewFile();
                plugin.getLogger().info("Default configuration file couldn't be found!");
                plugin.getLogger().info("Tried to create new default configuration file... State: " + (fileCreation ? "Successfully" : "Failed"));
                this.defaultSettings = true;
            }
            this.configuration = YamlConfiguration.loadConfiguration((File)this.file);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void save() {
        try {
            this.configuration.save(this.file);
        }
        catch (Throwable throwable) {
            this.plugin.getLogger().warning("Could not save configuration file!");
            throwable.printStackTrace();
        }
    }

    public void set(SettingOption setting, Object value) {
        this.configuration.set(this.settingToValidString(setting), value);
        this.hashedValues.put(setting, value);
    }

    public Object get(SettingOption setting) {
        Object object = this.hashedValues.get((Object)setting) == null ? this.configuration.get(this.settingToValidString(setting)) : this.hashedValues.get((Object)setting);
        this.hashedValues.putIfAbsent(setting, object);
        if (object instanceof String) {
            return this.replaceStringInformation((String)object);
        }
        return object;
    }

    public String replaceStringInformation(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text.replace("%new%", "\n"));
    }

    protected String settingToValidString(SettingOption setting) {
        return setting.toString().toLowerCase().replace("_", ".");
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.fileName;
    }

    public String getPath() {
        return this.filePath;
    }

    public boolean useDefaultSettings() {
        return this.defaultSettings;
    }
}

