/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin.events;

import de.rayzs.controlplayer.api.control.ControlInstance;
import de.rayzs.controlplayer.api.control.ControlManager;
import java.lang.reflect.Field;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.util.Vector;

public class EntityDamageByEntity
implements Listener {
    @EventHandler
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        int instanceState;
        Player player;
        if (event.getDamager() instanceof Player) {
            player = (Player)event.getDamager();
            instanceState = ControlManager.getInstanceState(player);
            ControlInstance instance = ControlManager.getControlInstance(player);
            if (instanceState == 0) {
                if (instance.victim() == player) {
                    return;
                }
                Player victim = instance.victim();
                try {
                    Class<?> clazz = event.getClass();
                    Field field = clazz.getDeclaredField("damager");
                    field.setAccessible(true);
                    field.set(event, victim);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).getHealth() - event.getDamage() < 0.5) {
                    event.setCancelled(true);
                    player.damage(event.getDamage(), (Entity)victim);
                }
            }
        }
        if (event.getEntity() instanceof Player) {
            player = (Player)event.getEntity();
            Player attacker = event.getDamager() instanceof Player ? (Player)event.getDamager() : null;
            instanceState = ControlManager.getInstanceState(player);
            if (instanceState == 1) {
                ControlInstance controlInstance = ControlManager.getControlInstance(player);
                Player controller = controlInstance.controller();
                event.setCancelled(false);
                double healthAfterDamage = player.getHealth() - event.getDamage();
                if (!event.isCancelled()) {
                    this.pushPlayer((Entity)controller, event.getDamager());
                }
                if (healthAfterDamage < 0.5) {
                    event.setCancelled(true);
                    player.setHealth(0.0);
                } else {
                    controller.setHealth(healthAfterDamage < 0.5 ? 0.0 : healthAfterDamage);
                }
            }
        }
    }

    private void pushPlayer(Entity victim, Entity attacker) {
        Vector vector = new Vector(0.0, -0.078375, 0.0);
        if (attacker != null) {
            Player attackerAsPlayer;
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            Location victimLocation = victim.getLocation();
            Location attackerLocation = attacker.getLocation();
            double deltaX = victimLocation.getX() - attackerLocation.getX();
            double deltaZ = victimLocation.getZ() - attackerLocation.getZ();
            double y = 0.36075;
            while (deltaX * deltaX + deltaZ * deltaZ < 1.0E-4) {
                deltaX = threadLocalRandom.nextDouble() - threadLocalRandom.nextDouble() * 0.01;
                deltaZ = threadLocalRandom.nextDouble() - threadLocalRandom.nextDouble() * 0.01;
            }
            double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
            deltaX = deltaX / distance * 0.4;
            deltaZ = deltaZ / distance * 0.4;
            if (attacker instanceof Player && !(attackerAsPlayer = (Player)attacker).isSneaking()) {
                double yaw = (double)attackerLocation.getYaw() * Math.PI / 180.0;
                deltaX += -Math.sin(yaw) * 1.5;
                deltaZ = Math.cos(yaw) * 1.5;
                y += 0.1;
                deltaX *= 0.6;
                deltaZ *= 0.6;
            }
            vector = new Vector(deltaX, y, deltaZ);
        }
        victim.setVelocity(vector);
    }
}

