/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin.commands;

import de.rayzs.controlplayer.api.control.ControlManager;
import de.rayzs.controlplayer.api.control.ControlState;
import de.rayzs.controlplayer.api.files.messages.MessageManager;
import de.rayzs.controlplayer.api.files.messages.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ControlPlayerCommand
extends MessageManager
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean sendHelp = true;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.ONLY_PLAYERS));
            return true;
        }
        if (!sender.isOp() && !sender.hasPermission("controlplayer.use")) {
            sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.NO_PERMISSION));
            return true;
        }
        if (args.length == 1) {
            sendHelp = false;
            Player player = (Player)sender;
            int playerInstance = ControlManager.getInstanceState(player);
            switch (playerInstance) {
                case 0: {
                    sender.sendMessage(ControlManager.deleteControlInstance(player) ? ControlPlayerCommand.getMessage(MessageType.STOPPED_CONTROLLING) : ControlPlayerCommand.getMessage(MessageType.ERROR));
                    break;
                }
                default: {
                    sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.BEING_CONTROLLED));
                    break;
                }
                case -1: {
                    Player victim = Bukkit.getPlayer((String)args[0]);
                    if (victim != null) {
                        int victimInstance = ControlManager.getInstanceState(victim);
                        if (victim != player) {
                            if (!victim.isOp() && !victim.hasPermission("controlplayer.bypass")) {
                                if (!victim.isDead()) {
                                    if (victimInstance != 1) {
                                        ControlState state = ControlManager.createControlInstance(player, victim);
                                        if (state == ControlState.SUCCESS) {
                                            sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.SUCCESS).replace("%player%", victim.getName()));
                                            break;
                                        }
                                        sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.ERROR));
                                        break;
                                    }
                                    sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.ALREADY_CONTROLLED));
                                    break;
                                }
                                sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.NOT_ALIVE));
                                break;
                            }
                            sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.PLAYER_IMUN));
                            break;
                        }
                        sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.SELF_CONTROL));
                        break;
                    }
                    sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.ONLY_PLAYERS));
                }
            }
        }
        if (sendHelp) {
            sender.sendMessage(ControlPlayerCommand.getMessage(MessageType.USAGE));
        }
        return true;
    }
}

