/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.plugin;

import de.rayzs.controlplayer.api.files.settings.SettingType;
import de.rayzs.controlplayer.api.files.settings.SettingsManager;
import de.rayzs.controlplayer.api.web.WebConnection;
import de.rayzs.controlplayer.plugin.bstats.Metrics;
import de.rayzs.controlplayer.plugin.commands.ControlPlayerCommand;
import de.rayzs.controlplayer.plugin.commands.ControlPlayerReloadCommand;
import de.rayzs.controlplayer.plugin.commands.ControlPlayerTabCompleter;
import de.rayzs.controlplayer.plugin.events.AsyncPlayerChat;
import de.rayzs.controlplayer.plugin.events.BlockBreak;
import de.rayzs.controlplayer.plugin.events.BlockPlace;
import de.rayzs.controlplayer.plugin.events.EntityDamage;
import de.rayzs.controlplayer.plugin.events.EntityDamageByEntity;
import de.rayzs.controlplayer.plugin.events.EntityTargetLivingEntity;
import de.rayzs.controlplayer.plugin.events.PlayerAnimation;
import de.rayzs.controlplayer.plugin.events.PlayerChangeWorld;
import de.rayzs.controlplayer.plugin.events.PlayerDeath;
import de.rayzs.controlplayer.plugin.events.PlayerDropItem;
import de.rayzs.controlplayer.plugin.events.PlayerInteract;
import de.rayzs.controlplayer.plugin.events.PlayerInteractAtEntity;
import de.rayzs.controlplayer.plugin.events.PlayerJoin;
import de.rayzs.controlplayer.plugin.events.PlayerPickupItem;
import de.rayzs.controlplayer.plugin.events.PlayerQuit;
import de.rayzs.controlplayer.plugin.events.PlayerToggleFlight;
import de.rayzs.controlplayer.plugin.events.PlayerToggleSneak;
import de.rayzs.controlplayer.plugin.events.PlayerToggleSprint;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ControlPlayerPlugin
extends JavaPlugin {
    private static ControlPlayerPlugin instance;
    private boolean latestVersion = true;
    private final WebConnection web = new WebConnection();
    private int updaterTaskId;
    private final String[] mainCommandNames = new String[]{"cp", "controlplayer", "cplayer", "controlp"};
    private final String[] reloadCommandNames = new String[]{"controlplayerreload", "controlplayerr", "cpr", "cpreload"};
    private final Class<?>[] listenerClasses = new Class[]{PlayerChangeWorld.class, PlayerDeath.class, PlayerInteract.class, PlayerInteractAtEntity.class, PlayerAnimation.class, EntityDamage.class, EntityDamageByEntity.class, EntityTargetLivingEntity.class, PlayerToggleFlight.class, PlayerToggleSneak.class, PlayerToggleSprint.class, PlayerPickupItem.class, PlayerDropItem.class, PlayerJoin.class, PlayerQuit.class, BlockBreak.class, BlockPlace.class, AsyncPlayerChat.class};

    public void onEnable() {
        instance = this;
        this.startUpdaterTask();
        this.registerCommands();
        this.registerEvents();
        new Metrics(this, 15651);
    }

    public void onDisable() {
    }

    public static ControlPlayerPlugin getInstance() {
        return instance;
    }

    public boolean isLatestVersion() {
        return this.latestVersion;
    }

    protected void registerEvents() {
        for (Class<?> clazz : this.listenerClasses) {
            try {
                Listener listener = (Listener)clazz.newInstance();
                this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
            }
            catch (IllegalAccessException | InstantiationException exception) {
                this.getLogger().warning("Could not register the listener-class [" + clazz.getSimpleName() + "]!");
                this.getLogger().warning("Error message:");
                exception.printStackTrace();
            }
        }
    }

    protected void registerCommands() {
        PluginCommand command;
        ControlPlayerCommand mainCommandClass = new ControlPlayerCommand();
        ControlPlayerReloadCommand reloadCommandClass = new ControlPlayerReloadCommand();
        ControlPlayerTabCompleter tabCompleterClass = new ControlPlayerTabCompleter();
        for (String commandName : this.mainCommandNames) {
            command = this.getCommand(commandName);
            command.setExecutor((CommandExecutor)mainCommandClass);
            command.setTabCompleter((TabCompleter)tabCompleterClass);
        }
        for (String commandName : this.reloadCommandNames) {
            command = this.getCommand(commandName);
            command.setExecutor((CommandExecutor)reloadCommandClass);
        }
    }

    protected void startUpdaterTask() {
        boolean update;
        Object updateObject = SettingsManager.getSetting(SettingType.UPDATER_ENABLED);
        boolean bl = update = updateObject == null || (Boolean)updateObject != false;
        if (!update) {
            return;
        }
        Object delayObject = SettingsManager.getSetting(SettingType.UPDATER_DELAY);
        int delay = delayObject == null ? 18000 : (Integer)delayObject;
        this.updaterTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            String result = this.web.connect("https://www.rayzs.de/products/controlplayer/version/index.php").getResult();
            if (!result.equals(this.getDescription().getVersion())) {
                Bukkit.getScheduler().cancelTask(this.updaterTaskId);
                if (result.equals("nohost")) {
                    this.getLogger().warning("Failed reaching web host! (firewall?)");
                } else if (result.equals("exception")) {
                    this.getLogger().warning("Failed creating web instance! (outdated java version?)");
                } else {
                    this.getLogger().warning("You're using an outdated version of this plugin!");
                    this.getLogger().warning("Please update it on: https://www.rayzs.de/products/controlplayer/page");
                }
                this.latestVersion = false;
            }
        }, 20L, (long)delay);
    }
}

