/*
 * Decompiled with CFR 0.152.
 */
package de.rayzs.controlplayer.api.files.settings;

import de.rayzs.controlplayer.api.files.settings.SettingType;
import de.rayzs.controlplayer.configurator.FileConfigurator;
import java.util.HashMap;

public class SettingsManager {
    private static FileConfigurator FILE = new FileConfigurator("config", "./plugins/ControlPlayer");
    private static final HashMap<SettingType, Object> SETTINGS = new HashMap();
    private static final String SETTING_PATH = "settings.";

    public static void reload(boolean firstLoad) {
        SettingType[] settingTypes;
        if (!firstLoad) {
            FILE = new FileConfigurator("config", "./plugins/ControlPlayer");
            SETTINGS.clear();
        }
        for (SettingType settingType : settingTypes = SettingType.values()) {
            Object obj;
            String settingPath = SETTING_PATH + settingType.toString().toLowerCase().replace("_", ".");
            if (FILE.loadDefault()) {
                SettingsManager.setMessageToFile(settingType);
            }
            if ((obj = FILE.get(settingPath)) == null) {
                System.out.println("Resetted '" + settingPath + "' from " + FILE.getFile().getName() + " because the value is null!");
                SettingsManager.setMessageToFile(settingType);
                obj = FILE.get(settingPath);
            }
            SETTINGS.put(settingType, obj);
        }
    }

    public static Object getSetting(SettingType settingType) {
        return SETTINGS.get((Object)settingType);
    }

    protected static void setMessageToFile(SettingType settingType) {
        String defaultPath = SETTING_PATH + settingType.toString().toLowerCase().replace("_", ".");
        switch (settingType) {
            case APIMODE: {
                FILE.set(defaultPath, false);
                break;
            }
            case UPDATER_DELAY: {
                FILE.set(defaultPath, 18000);
                break;
            }
            case CONTROL_RUNNING_SYNCDELAY: {
                FILE.set(defaultPath, 0);
                break;
            }
            case CONTROL_RUNNING_FORCECHAT_BYPASSMESSAGE: {
                FILE.set(defaultPath, "-b ");
                break;
            }
            default: {
                FILE.set(defaultPath, true);
            }
        }
        FILE.save();
    }

    static {
        SettingsManager.reload(true);
    }
}

